
# Shree Shyam Vartika (SSV) Website Project Documentation

## Project Overview
**Business Name:** Shree Shyam Vartika (SSV)  
**Type:** Event Management (Weddings, Engagements, Receptions, Birthdays, Corporate Parties)  
**Purpose:** Showcase services, gallery, collect enquiries, admin-managed content  
**Tech Stack:** PHP, MySQL, HTML, CSS, JavaScript

**Design Style:** Modern, Glossmorphic, Elegant, Wedding/Event Theme, Royal Colors (Purple/Maroon/Gold), Black & White, Transparent Blur / Smoky Effects, Creative Wedding Fonts

---

## Folder & File Structure

```
SSV-Website/
│
├── public/                  # User-facing website files
│   ├── index.php           # Home page
│   ├── services.php        # Services page
│   ├── gallery.php         # Gallery page
│   ├── contact.php         # Contact page
│   ├── about.php           # Full About Us page
│   ├── assets/              # All static assets
│   │   ├── css/
│   │   │   └── style.css
│   │   ├── js/
│   │   │   └── script.js
│   │   ├── images/
│   │   │   └── ...          # Banner, gallery, icons
│   │   └── videos/
│   │       └── ...          # Gallery / Hero videos
│   └── favicon.ico
│
├── admin/                  # Admin panel files
│   ├── index.php            # Admin login
│   ├── dashboard.php        # Admin dashboard overview
│   ├── manage_services.php  # Add/Edit/Delete services
│   ├── manage_gallery.php   # Upload/Edit/Delete images/videos
│   ├── manage_testimonials.php
│   ├── manage_enquiries.php
│   ├── settings.php         # Admin profile / business info
│   ├── assets/
│   │   ├── css/
│   │   ├── js/
│   │   └── images/
│
├── config/
│   └── db.php               # Database connection file
│
├── uploads/                 # Media uploaded from admin panel
│   ├── services/
│   ├── gallery/
│   └── testimonials/
│
├── includes/                # Reusable components
│   ├── header.php
│   ├── footer.php
│   └── navbar.php
│
├── .htaccess                # Security rules, redirects
└── README.md                # Project documentation
```

---

## Frontend Layout & Wireframes

### 1. Home Page (`index.php`)
- **Hero Banner:**
  - Full-width banner with images/video carousel
  - Overlay with semi-transparent blur / smokey effect
  - Text overlay with creative wedding tagline (*“Making Your Special Day Unforgettable”*)
  - CTA button: *“Plan Your Event”*
- **Main Services Preview (3–4 featured services)**
  - Glassmorphic cards with icon/image, short description, hover glow effect
  - Button: *“See All Services”* → links to `services.php`
- **Gallery Sneak Peek**
  - 4–6 featured images/videos with hover effect
  - Button: *“View Full Gallery”* → links to `gallery.php`
- **Star Rating Section**
  - Average star rating (⭐ 4.8/5 based on X events)
  - Optional carousel of selected testimonials
- **Quick Contact / WhatsApp**
  - Floating WhatsApp icon (right bottom)
  - Quick contact info (phone/email)
- **About Us Preview**
  - Small text + image
  - Button: *“Learn More About Us”* → links to `about.php`

---

### 2. Services Page (`services.php`)
- Full list of services
- Each service has:
  - Image/Icon
  - Title
  - Short Description
  - **Optional:** Capacity & Per Plate Charges (only if relevant)
- Glassmorphic cards with hover effect

---

### 3. Gallery Page (`gallery.php`)
- Grid layout (masonry or uniform tiles)
- Filters by service type (Wedding, Birthday, Engagement, Corporate, etc.)
- Images & videos supported
- Hover overlay with soft transparency
- Click to open lightbox for larger view or video play

---

### 4. Contact Page (`contact.php`)
- Form Fields:
  - Name, Email, Phone, Service Interested, Message
- Submit button → stores enquiry in admin panel
- Google Maps embed showing business location
- Floating WhatsApp icon
- Optional: Address & “Get Directions” link

---

### 5. About Us Page (`about.php`)
- Full detailed description
  - Business story, mission, vision
- Team section
  - Photos, names, roles, optional short bio
- Achievements / Milestones
  - Number of events, years of experience, recognitions
- Why Choose Us section
- Admin can edit all texts and images

---

## Admin Panel (`admin/`)

### Dashboard (`dashboard.php`)
- Overview of enquiries, services, gallery, testimonials
- Quick stats: number of events, average rating

### Manage Services (`manage_services.php`)
- Add/Edit/Delete services
- Upload service image/icon
- Enter title, description, capacity, per plate charges
- Mark as Featured for Home page

### Manage Gallery (`manage_gallery.php`)
- Upload images/videos
- Assign service category (for filters)
- Edit/Delete media
- Preview grid

### Manage Testimonials (`manage_testimonials.php`)
- Add/Edit/Delete client feedback
- Star rating + text feedback
- Checkbox: Show on Home page (optional)

### Manage Enquiries (`manage_enquiries.php`)
- View all contact form submissions
- Search/filter by service/date/name
- Mark as read/unread, archive, delete
- Export CSV option (optional)

### Settings (`settings.php`)
- Admin profile (username, password)
- Update business info
- Change Google Maps link
- Update header/footer info

---

## Design & UI Guidelines

- **Theme:** Modern, Glossmorphic, Elegant, Wedding/Event style
- **Primary Colors:** Royal Purple / Deep Maroon, Gold accents
- **Secondary Colors:** Black & White, transparent blur / smoky overlays
- **Fonts:** 
  - Headings: Elegant Serif / Calligraphy wedding-style font
  - Body: Clean Sans-Serif
- **Effects:**
  - Glassmorphic cards and panels
  - Smooth hover and scroll animations
  - Subtle particle/bokeh effects for hero/gallery backgrounds
- **Layout:** Clean, spacious, minimal text, visually rich

---

## Notes & Recommendations

1. Use `includes/header.php` and `includes/footer.php` to avoid repetition.
2. Separate CSS/JS for frontend (`public/assets`) and admin (`admin/assets`).
3. Store all media uploaded via admin in `uploads/` folders with proper naming.
4. Ensure responsive design for mobile and tablet devices.
5. Implement secure login for admin panel and protect it via `.htaccess` if needed.
6. Floating WhatsApp button visible across all pages.
7. Gallery filtering should be dynamic, admin can assign categories.

---

## Wireframe Sketch (Text-Based)

**Home Page Flow:**
```
---------------------------------------------------
| Hero Banner: Image/Video + Tagline + CTA       |
---------------------------------------------------
| Featured Services (3-4)                        |
---------------------------------------------------
| Gallery Preview (4-6 items)                     |
---------------------------------------------------
| Star Rating Section (Optional testimonials)     |
---------------------------------------------------
| Quick Contact / WhatsApp                        |
---------------------------------------------------
| About Us Preview + Learn More Button            |
---------------------------------------------------
| Footer: Contact info, social links, copyright  |
---------------------------------------------------
```

**Services Page Flow:**
```
---------------------------------------------------
| Page Title: Our Services                        |
---------------------------------------------------
| Service Cards:                                  |
| [Image/Icon] Title                              |
| Description                                     |
| Optional: Capacity / Per Plate Charges          |
| Hover Effects                                   |
---------------------------------------------------
```

**Gallery Page Flow:**
```
---------------------------------------------------
| Filters: Wedding | Birthday | Engagement ...   |
---------------------------------------------------
| Media Grid: Images & Videos                     |
| Click → Lightbox / Video Player                 |
---------------------------------------------------
```

**Contact Page Flow:**
```
---------------------------------------------------
| Contact Form: Name, Email, Phone, Service ...  |
---------------------------------------------------
| Google Map Embed                               |
---------------------------------------------------
| Floating WhatsApp Icon                          |
---------------------------------------------------
```

**About Us Page Flow:**
```
---------------------------------------------------
| Business Story / Mission / Vision              |
---------------------------------------------------
| Team Section: Photos + Roles + Bio             |
---------------------------------------------------
| Achievements / Milestones                       |
---------------------------------------------------
| Why Choose Us                                   |
---------------------------------------------------
```

---

**End of SSV Project Documentation**
