<?php
// Get business settings
require_once __DIR__ . '/../config/db.php';

function getBusinessSetting($key, $default = '') {
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT setting_value FROM business_settings WHERE setting_key = ?");
        $stmt->execute([$key]);
        $result = $stmt->fetch();
        return $result ? $result['setting_value'] : $default;
    } catch(Exception $e) {
        // Return default if database is not available yet
        return $default;
    }
}

$business_name = getBusinessSetting('business_name', 'Shree Shyam Vartika');
$business_tagline = getBusinessSetting('business_tagline', 'Making Your Special Day Unforgettable');
$business_phone = getBusinessSetting('business_phone', '+91-9876543210');
$business_email = getBusinessSetting('business_email', 'info@shreeshyamvartika.com');
$whatsapp_number = getBusinessSetting('whatsapp_number', '+91-9876543210');

// Get current page name for active menu highlighting
$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' . $business_name : $business_name . ' - ' . $business_tagline; ?></title>
    <meta name="description" content="<?php echo isset($page_description) ? $page_description : 'Premier event management services in wedding, engagement, birthday, and corporate events. ' . $business_tagline; ?>">
    <meta name="keywords" content="event management, wedding planner, engagement ceremony, birthday party, corporate events, <?php echo $business_name; ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo strpos($_SERVER['REQUEST_URI'], '/admin/') !== false ? '../public/favicon.ico' : 'favicon.ico'; ?>">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&family=Poppins:wght@300;400;500;600;700&family=Dancing+Script:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css">
    
    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo strpos($_SERVER['REQUEST_URI'], '/admin/') !== false ? '../public/assets/css/style.css' : 'assets/css/style.css'; ?>">
    
    <!-- Additional CSS for specific pages -->
    <?php if (isset($additional_css)): ?>
        <?php foreach ($additional_css as $css): ?>
            <link rel="stylesheet" href="<?php echo $css; ?>">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body class="<?php echo isset($body_class) ? $body_class : ''; ?>">
    
    <!-- Preloader -->
    <div class="preloader" id="preloader">
        <div class="preloader-content">
            <div class="wedding-rings">
                <div class="ring ring1"></div>
                <div class="ring ring2"></div>
            </div>
            <h2 class="preloader-text"><?php echo $business_name; ?></h2>
            <p class="preloader-tagline"><?php echo $business_tagline; ?></p>
        </div>
    </div>

    <!-- WhatsApp Floating Button -->
    <div class="whatsapp-float">
        <a href="https://wa.me/<?php echo str_replace(['+', '-', ' '], '', $whatsapp_number); ?>?text=Hi%20<?php echo urlencode($business_name); ?>,%20I%20would%20like%20to%20inquire%20about%20your%20event%20services." target="_blank" class="whatsapp-btn">
            <i class="fab fa-whatsapp"></i>
            <span class="whatsapp-tooltip">Chat with us on WhatsApp</span>
        </a>
    </div>

    <!-- Main Wrapper -->
    <div class="main-wrapper">
        
        <!-- Header -->
        <header class="header" id="header">
            <div class="header-overlay"></div>
            
            <!-- Top Bar -->
            <div class="top-bar">
                <div class="container">
                    <div class="top-bar-content">
                        <div class="contact-info">
                            <span class="contact-item">
                                <i class="fas fa-phone"></i>
                                <a href="tel:<?php echo str_replace(['+', '-', ' '], '', $business_phone); ?>"><?php echo $business_phone; ?></a>
                            </span>
                            <span class="contact-item">
                                <i class="fas fa-envelope"></i>
                                <a href="mailto:<?php echo $business_email; ?>"><?php echo $business_email; ?></a>
                            </span>
                        </div>
                        <div class="social-links">
                            <?php if (getBusinessSetting('facebook_url')): ?>
                                <a href="<?php echo getBusinessSetting('facebook_url'); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
                            <?php endif; ?>
                            <?php if (getBusinessSetting('instagram_url')): ?>
                                <a href="<?php echo getBusinessSetting('instagram_url'); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                            <?php endif; ?>
                            <?php if (getBusinessSetting('youtube_url')): ?>
                                <a href="<?php echo getBusinessSetting('youtube_url'); ?>" target="_blank"><i class="fab fa-youtube"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Navigation -->
            <nav class="main-nav" id="mainNav">
                <div class="container">
                    <div class="nav-content">
                        <!-- Logo -->
                        <div class="logo">
                            <a href="<?php echo strpos($_SERVER['REQUEST_URI'], '/admin/') !== false ? '../public/' : ''; ?>index.php">
                                <h1 class="logo-text"><?php echo $business_name; ?></h1>
                                <p class="logo-tagline"><?php echo $business_tagline; ?></p>
                            </a>
                        </div>

                        <!-- Navigation Menu -->
                        <?php if (strpos($_SERVER['REQUEST_URI'], '/admin/') === false): ?>
                        <ul class="nav-menu" id="navMenu">
                            <li class="nav-item">
                                <a href="index.php" class="nav-link <?php echo $current_page == 'index' ? 'active' : ''; ?>">
                                    <i class="fas fa-home"></i> Home
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="services.php" class="nav-link <?php echo $current_page == 'services' ? 'active' : ''; ?>">
                                    <i class="fas fa-concierge-bell"></i> Services
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="gallery.php" class="nav-link <?php echo $current_page == 'gallery' ? 'active' : ''; ?>">
                                    <i class="fas fa-images"></i> Gallery
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="about.php" class="nav-link <?php echo $current_page == 'about' ? 'active' : ''; ?>">
                                    <i class="fas fa-info-circle"></i> About Us
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="contact.php" class="nav-link <?php echo $current_page == 'contact' ? 'active' : ''; ?>">
                                    <i class="fas fa-envelope"></i> Contact
                                </a>
                            </li>
                        </ul>
                        <?php endif; ?>

                        <!-- Mobile Menu Toggle -->
                        <div class="mobile-menu-toggle" id="mobileMenuToggle">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                </div>
            </nav>
        </header>

        <!-- Mobile Navigation Overlay -->
        <div class="mobile-nav-overlay" id="mobileNavOverlay">
            <div class="mobile-nav-content">
                <button class="mobile-nav-close" id="mobileNavClose">
                    <i class="fas fa-times"></i>
                </button>
                <?php if (strpos($_SERVER['REQUEST_URI'], '/admin/') === false): ?>
                <ul class="mobile-nav-menu">
                    <li><a href="index.php" class="<?php echo $current_page == 'index' ? 'active' : ''; ?>"><i class="fas fa-home"></i> Home</a></li>
                    <li><a href="services.php" class="<?php echo $current_page == 'services' ? 'active' : ''; ?>"><i class="fas fa-concierge-bell"></i> Services</a></li>
                    <li><a href="gallery.php" class="<?php echo $current_page == 'gallery' ? 'active' : ''; ?>"><i class="fas fa-images"></i> Gallery</a></li>
                    <li><a href="about.php" class="<?php echo $current_page == 'about' ? 'active' : ''; ?>"><i class="fas fa-info-circle"></i> About Us</a></li>
                    <li><a href="contact.php" class="<?php echo $current_page == 'contact' ? 'active' : ''; ?>"><i class="fas fa-envelope"></i> Contact</a></li>
                </ul>
                <?php endif; ?>
            </div>
        </div>

        <!-- Main Content -->
        <main class="main-content" id="mainContent">